import { Locale, defaultLocale } from "@/i18n.config";

export const checkUrlByLanguage = (lang: Locale = defaultLocale, path: string = '/') => {
  let url = `${lang === defaultLocale ? '' : `/${lang}`}${path}`;

  url = url.replaceAll(/\/\/+/g, '/');

  if (url.charAt(0) !== '/') {
    return `/${url}`;
  }

  return url;
}
