import { FLOOR_LIST } from '@/constants';

export type OptionType = {
  key: string;
  name: string;
};

export type ImageFormatType = {
  ext: string;
  hash: string;
  height: string;
  mime: string;
  name: string;
  path: null;
  size: string;
  url: string;
  width: string;
};

export type ImageType = {
  alt?: string;
  height: number;
  src: string;
  width: number;
};

export type FileFormatsType = {
  large?: ImageFormatType | null;
  small?: ImageFormatType | null;
  medium?: ImageFormatType | null;
  thumbnail?: ImageFormatType | null;
}

export type FileType = {
  alternativeText?: string | null;
  caption?: string | null;
  createdAt: string;
  ext: string;
  folderPath: string;
  formats?: FileFormatsType | null;
  hash: string;
  height: number;
  id: string;
  mime: string;
  name: string;
  previewUrl?: string | null;
  provider: string;
  provider_metadata?: string | null;
  size: number;
  updatedAt?: string;
  url: string;
  width: number;
};

export type LibrasVideosType = {
  id: number;
  caption: string;
  url: string;
};

export type NextPageType = {
  id: number;
  name: string;
  title: string;
  floor: number;
  slug: string;
}

export type PositionType = {
  id: number;
  x: number;
  y: number;
};

export type PinPositionType = {
  x: number;
  y: number;
};

export type WindowDimensionsType = {
  height?: number;
  width?: number;
};

export type AudioType = {
  id: number;
  name?: string;
  src: string;
}

export type VideoType = {
  youTubeId: string;
  cover: ImageType;
}

export type FloorKeyType = typeof FLOOR_LIST[number];

export type TextContentType = {
  content: string;
  cover: ImageType;
  id: number;
  number: string;
  position: PinPositionType;
  title: string;
  type: 'text';
};

export type AudioContentType = {
  audios: AudioType[];
  cover: ImageType;
  id: number;
  number: string;
  position: PinPositionType;
  title: string;
  type: 'audio';
};

export type YouTubeContentType = {
  cover: ImageType;
  id: number;
  number: string;
  position: PinPositionType;
  title: string;
  type: 'video';
  videos: VideoType[];
};

export type SectionType = {
  id: number;
  title: string;
  position?: PositionType
};

export type SectionContentType = {
  id: number;
  title: string;
  content: string;
  libras_videos: LibrasVideosType[];
  audio_descriptions: FileType[];
  position: PositionType;
  cover?: FileType;
};

export type RoomContentType = {
  id: number;
  name: string;
  title: string;
  floor: number;
  createdAt: string;
  updatedAt?: string;
  locale: string;
  slug: string;
  show_quiz: boolean;
  code?: string;
  cover: FileType;
  position: PositionType;
  sections: SectionContentType[];
  nextPage?: NextPageType;
};

export type RoomType = {
  id: number;
  name: string;
  title: string;
  floor: number;
  createdAt: string;
  updatedAt: string;
  locale: string;
  slug: string;
  show_quiz?: boolean;
  code?: string;
  position?: PositionType;
  sections: SectionType[];
};

export type MainMenuContentType = {
  title?: string;
  languages?: string;
  settings?: string;
  rating?: string;
  contact?: string;
  tutorial?: string;
  start?: string;
};

export type QuizChoiceType = {
  id: number;
  is_correct: boolean;
  text: string;
}

export type QuizQuestionType = {
  id: number;
  question: string;
  correct_answer_description: string;
  index: 1;
  choices: QuizChoiceType[];
};

export type QuizType = {
  id: number;
  createdAt: string;
  updatedAt?: string;
  locale: string;
  subtitle: string;
  questions: QuizQuestionType[];
};

export type AboutContentType = {
  id: number;
  title: string;
  text: string;
  createdAt: string;
  updatedAt?: string;
  locale: string;
  image?: FileType;
};

export type GlossaryType = {
  id: number;
  name: string;
  description: string;
  createdAt: string;
  updatedAt?: string;
  locale: string;
};
