import React, { ReactNode } from 'react';

import Header from '@/sections/Header';
import Navigation from '@/sections/Navigation';
import { NavigationActiveType } from '@/sections/Navigation';
import { MenuProvider } from '@/context/MenuContext';
import { MessageProvider } from '@/context/MessageContext';
import { SettingsProvider } from '@/context/SettingsContext/SettingsContext';
import { getDictionary } from '@/libraries/dictionary';
import { Locale, defaultLocale } from '@/i18n.config';
import { HeaderContentType } from '.';

export default async function PageTemplate({
  children, lang = defaultLocale, navigationActive,
}: {
  children?: ReactNode; lang?: Locale; navigationActive?: NavigationActiveType;
}) {
  const d = await getDictionary(lang);

  {/* API INTEGRATION */}
  const headerContent = {
    logoAriaLabel: d.header.logoAriaLabel,
    menuAriaLabel: d.header.menuAriaLabel,
    mainMenu: {
      title: d.mainMenu.title,
      languages: d.mainMenu.languages,
      settings: d.mainMenu.settings,
      rating: d.mainMenu.rating,
      contact: d.mainMenu.contact,
      tutorial: d.mainMenu.tutorial,
      start: d.mainMenu.start,
      facebook: 'https://www.facebook.com/',
      instagram: 'https://www.instagram.com/',
      youtube: 'https://www.youtube.com/',
      mjb: 'http://museujardimbotanico.org.br',
    },
    languageMenu: {
      title: d.languageMenu.title,
      description: d.languageMenu.description,
    },
    settingsMenu: {
      title: d.settingsMenu.title,
      description: d.settingsMenu.description,
      options: {
        highContrast: {
          title: d.settingsMenu.options.highContrast.title,
          ariaLabel: d.settingsMenu.options.highContrast.ariaLabel,
        },
        font: {
          title: d.settingsMenu.options.font.title,
          defaultAriaLabel: d.settingsMenu.options.font.defaultAriaLabel,
          largeAriaLabel: d.settingsMenu.options.font.largeAriaLabel,
        },
        audioDescription: {
          title: d.settingsMenu.options.audioDescription.title,
          ariaLabel: d.settingsMenu.options.audioDescription.ariaLabel,
        },
        camera: {
          title: d.settingsMenu.options.camera.title,
          ariaLabel: d.settingsMenu.options.camera.ariaLabel,
        },
      },
    },
    ratingMenu: {
      title: d.ratingMenu.title,
      description: d.ratingMenu.description,
      formDescription: d.ratingMenu.formDescription,
      namePlaceholder: d.ratingMenu.namePlaceholder,
      emailPlaceholder: d.ratingMenu.emailPlaceholder,
      subjectPlaceholder: d.ratingMenu.subjectPlaceholder,
      messagePlaceholder: d.ratingMenu.messagePlaceholder,
      topicOptions: d.ratingMenu.topicOptions,
    },
    contactMenu: {
      title: d.contactMenu.title,
      description: d.contactMenu.description,
      formDescription: d.ratingMenu.formDescription,
      namePlaceholder: d.ratingMenu.namePlaceholder,
      emailPlaceholder: d.ratingMenu.emailPlaceholder,
      subjectPlaceholder: d.ratingMenu.subjectPlaceholder,
      messagePlaceholder: d.ratingMenu.messagePlaceholder,
      topicOptions: d.ratingMenu.topicOptions,
    },
    tutorialMenu: {
      title: d.tutorialMenu.title,
    },
    startMenu: {
      title: d.startMenu.title,
    },
  } as HeaderContentType;

  return (
    <SettingsProvider>
      {navigationActive !== 'map' && (
        <MessageProvider>
          <MenuProvider>
            <Header lang={lang} content={headerContent} />
          </MenuProvider>
        </MessageProvider>
      )}
      {children}
      {!!navigationActive?.length && (
        <Navigation active={navigationActive} lang={lang} />
      )}
    </SettingsProvider>
  );
};
