import React from 'react';

interface Props {
  fill?: string,
  title?: string,
};


export default function MenuIcon({ fill = '#000000', title = 'Icone de menu' }: Props) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 20 20"
      fill={fill}
      strokeWidth={0}
    >
      <title>{title}</title>
      <path d="M17,6H3c-.5522,0-1-.4478-1-1s.4478-1,1-1h14c.5527,0,1,.4478,1,1s-.4473,1-1,1Z" />
      <path d="M17,11H3c-.5522,0-1-.4478-1-1s.4478-1,1-1h14c.5527,0,1,.4478,1,1s-.4473,1-1,1Z" />
      <path d="M17,16H3c-.5522,0-1-.4473-1-1s.4478-1,1-1h14c.5527,0,1,.4473,1,1s-.4473,1-1,1Z" />
    </svg>
  );
};
