import React from 'react';

import BasicCover from '@/components/BasicCover';
import YouTubePlayer from '@/components/YouTubePlayer';
import { getYouTubeVideoId } from '@/utils/getYouTubeVideoId';
import { FileType, LibrasVideosType } from '@/types';

import styles from './YouTubeContentSession.module.scss';

export default function YouTubeContentSession({
  cover, title = '', videos = [],
}: {
  cover?: FileType; title?: string; videos: LibrasVideosType[];
}) {
  return !!videos?.length && (
    <section className={styles.YouTubeContentSession}>
      {!!cover && (
        <div className={styles['cover-wrapper']}>
          <BasicCover cover={cover} />
        </div>
      )}
      {!!title?.length && (<h2 className={styles.title}>{title}</h2>)}
      {videos.map((v: LibrasVideosType) => {
        const youTubeId = getYouTubeVideoId(v?.url);

        if (youTubeId?.length) {
          return (
            <div key={v.id} className={styles['video-wrapper']}>
              {!!cover && (<YouTubePlayer videoId={youTubeId} />)}
            </div>
          )
        }
      })}
    </section>
  );
};
