import React from 'react';

import BasicCover from '@/components/BasicCover';
import HtmlContent from '@/components/HtmlContent';
import { FileType } from '@/types';

import styles from './TextContentSession.module.scss';

export default function TextContentSession({
  content = '', cover = null, title = '',
}: {
  content?: string; cover?: FileType | null; title?: string;
}) {
  return (
    <section
      className={styles[`TextContentSession--${!!cover ? 'with' : 'without'}-cover`]}
    >
      {!!cover && (
        <div className={styles['cover-wrapper']}>
          <BasicCover cover={cover} />
        </div>
      )}
      {!!title?.length && (<h2 className={styles.title}>{title}</h2>)}
      {!!content?.length && (
        <div className={styles['content-wrapper']}>
          <HtmlContent content={content} />
        </div>
      )}
    </section>
  );
};
