import React from 'react';

import { OptionType } from '@/types';

import styles from './RoomContentsNavigation.module.scss';

export default function RoomContentsNavigation({
  options = [], room = '', onClick,
}: {
  options: OptionType[]; room: string; onClick: (id: string) => void;
}) {
  return !!options?.length && !!onClick && (
    <section className={styles.RoomContentsNavigation}>
      {!!room?.length && (<p className={styles.room}>{room}</p>)}
      <ul className={styles.anchors}>
        {options.map((o: OptionType) => !!o?.key?.length && !!o?.name?.length && (
          <li key={o.key}>
            <button className={styles.anchor} type="button" onClick={() => onClick(o.key)}>
              {o.name}
            </button>
          </li>
        ))}
      </ul>
    </section>
  );
};
