'use client';

// import React, { useEffect, useMemo } from 'react';
import React, { useEffect } from 'react';

import AudioContentSession from '@/sections/AudioContentSession';
import QuizContentSection from '@/sections/QuizContentSection';
// import RoomContentsNavigation from '@/sections/RoomContentsNavigation';
import TextContentSession from '@/sections/TextContentSession';
import YouTubeContentSession from '@/sections/YouTubeContentSession';
import BackToTopButton from '@/components/BackToTopButton';
import NextRoomLink from '@/components/NextRoomLink';
import { slugify } from '@/utils/slugify';
import {
  LIBRAS_LOCALE,
  PT_AU_LOCALE,
  TEXT_LOCALE,
  Locale,
  defaultLocale,
} from '@/i18n.config';
// import { OptionType, QuizType, RoomContentType } from '@/types';
import { QuizType, RoomContentType } from '@/types';

import styles from './RoomContents.module.scss';

export default function RoomContents({
  content,
  lang = defaultLocale,
  quiz,
  room,
  section,
  translations: {
    backToTop = '',
    incorrectAnswer = '',
    nextRoom = '',
    questionTitle = '',
  }
}: {
  content?: RoomContentType;
  lang: Locale;
  quiz?: QuizType;
  room: string;
  section?: string;
  translations: {
    backToTop?: string;
    incorrectAnswer?: string;
    nextRoom?: string;
    questionTitle?: string;
  };
}) {
  const handleClickNavigation = (id: string = '') => {
    if (!!id?.length) {
      handleWindowScrollTop(id);
    }
  };

  const handleWindowScrollTop = (id: string | '' = '') => {
    let top = 0;

    if (!!id?.length) {
      const element = document.getElementById(id);

      top = element?.getBoundingClientRect()?.top || 0;
      top = top > 72 ? top - 72 : top;
    }

    window.scrollTo({ top, behavior: 'smooth' });
  };

  useEffect(() => {
    if (!!section?.length) {
      handleWindowScrollTop(section);
    }
  }, [section]);

  // const navigation: OptionType[] = useMemo(() => {
  //   const current = content?.sections?.map(
  //     (s) => ({ key: slugify(s?.title), name: s?.title }),
  //   ) || [];

  //   if (!!content?.show_quiz) {
  //     current.push({ key: 'quiz', name: 'Quiz' })
  //   }

  //   return current;
  // }, [content?.sections, content?.show_quiz]);

  return (
    <main className={styles.RoomContents}>
      <div className={styles.container}>
        {/* {!!navigation?.length && (
          <RoomContentsNavigation
            options={navigation}
            room={room}
            onClick={handleClickNavigation}
          />
        )} */}
        {content?.sections?.length && (
          <div>
            {content.sections.map((s) => {
              if (
                TEXT_LOCALE.includes(lang) &&
                !!s?.id &&
                !!s?.title?.length &&
                !!s?.content?.length
              ) {
                return (
                  <div
                    key={s.id}
                    id={slugify(s.title)}
                    className={styles['content-wrapper--text']}
                  >
                    <TextContentSession
                      content={s.content}
                      cover={s?.cover}
                      title={s.title}
                    />
                  </div>
                );
              }

              if (
                lang === PT_AU_LOCALE &&
                !!s?.title?.length &&
                !!s?.audio_descriptions?.length
              ) {
                return (
                  <div
                    key={s.id}
                    id={slugify(s.title)}
                    className={styles['content-wrapper--audio']}
                  >
                    <AudioContentSession
                      audios={s.audio_descriptions}
                      cover={s?.cover}
                      title={s.title}
                    />
                  </div>
                );
              } 

              if (
                lang === LIBRAS_LOCALE &&
                !!s?.title?.length &&
                !!s?.libras_videos?.length
              ) {
                return (
                  <div
                    key={s.id}
                    id={slugify(s.title)}
                    className={styles['content-wrapper--video']}
                  >
                    <YouTubeContentSession
                      cover={s.cover}
                      title={s.title}
                      videos={s.libras_videos}
                    />
                  </div>
                );
              }

              return null;
            })}
            {!!content?.show_quiz && !!quiz && (
              <div id="quiz" className={styles['content-wrapper--quiz']}>
                <QuizContentSection
                  quiz={quiz}
                  questionTitle={questionTitle}
                  incorrectAnswer={incorrectAnswer}
                />
              </div>
            )}
          </div>
        )}
        {!!backToTop?.length && handleWindowScrollTop && (
          <div className={styles['back-to-top-wrapper']}>
            <BackToTopButton cta={backToTop} onClick={handleWindowScrollTop} />
          </div>
        )}
        {!!content?.nextPage && (
          <NextRoomLink data={content.nextPage} lang={lang} cta={nextRoom} />
        )}
      </div>
    </main>
  );
};
