import React from 'react';

import BasicCover from '@/components/BasicCover/BasicCover';
import HtmlContent from '@/components/HtmlContent';
import QuizQuestion from '@/components/QuizQuestion';
import { FileType, QuizType } from '@/types';

import styles from './QuizContentSection.module.scss';

export default function QuizContentSection({
  cover, feedback, incorrectAnswer, questionTitle, quiz,
}: {
  cover?: FileType;
  feedback?: string;
  incorrectAnswer: string;
  questionTitle: string;
  quiz: QuizType;
}) {
  return (
    <section className={styles.QuizContentSection}>
      {!!cover && (
        <div className={styles['cover-wrapper']}>
          <BasicCover cover={cover} />
        </div>
      )}
      <h3 className={styles.title}>Quiz</h3>
      {!!quiz?.subtitle?.length && (
        <div className={styles.content}>
          <HtmlContent content={quiz.subtitle} />
        </div>
      )}
      {!!quiz?.questions?.length && (
        <div className={styles['quiz-list']}>
          {quiz.questions.map(
            ({ question, choices, correct_answer_description }, index: number) => (
              <div key={index} className={styles['quiz-item']}>
                <QuizQuestion
                  answer={correct_answer_description}
                  choices={choices}
                  question={question}
                  title={`${questionTitle} ${index + 1}`}
                  incorrect={incorrectAnswer}
                />
              </div>
            )
          )}
        </div>
      )}
      {!!feedback?.length && (
        <div className={styles.result}>
          <HtmlContent content={feedback} />
        </div>
      )}
    </section>
  );
};
