import React from 'react';
import Link from 'next/link';

import CameraIcon from '@/svgs/CameraIcon';
import MenuIcon from '@/svgs/MenuIcon';
import PinIcon from '@/svgs/PinIcon';
import { checkUrlByLanguage } from '@/utils/checkUrlByLanguage';
import { HOMEPAGE_SLUG } from '@/constants';
import { Locale, defaultLocale } from '@/i18n.config';

import styles from './Navigation.module.scss';
import { NavigationActiveType } from './';

export default function Navigation({
  active = HOMEPAGE_SLUG, lang = defaultLocale,
}: {
  active?: NavigationActiveType; lang?: Locale;
}) {
  return (
    <nav className={styles.Navigation}>
      <ol className={styles['Navigation__list']}>
        <li className={styles[`Navigation__item${active === 'code' ? '--active' : ''}`]}>
          <Link href={checkUrlByLanguage(lang, '/codigo')}>
            <CameraIcon /> Câmera
          </Link>
        </li>
        <li className={styles[`Navigation__item${active === 'home' ? '--active' : ''}`]}>
          <Link href={checkUrlByLanguage(lang, '/')}>
            <MenuIcon /> Índice
          </Link>
        </li>
        <li className={styles[`Navigation__item${active === 'map' ? '--active' : ''}`]}>
        <Link href={checkUrlByLanguage(lang, '/mapa')}>
            <PinIcon /> Mapa
          </Link>
        </li>
      </ol>
    </nav>
  );
};
