import React, { useContext } from 'react';

import MenuContext from '@/context/MenuContext/MenuContext';
import SubmenuTemplate from '@/templates/SubmenuTemplate';
import ContactIcon from '@/svgs/ContactIcon';
import FacebookIcon from '@/svgs/FacebookIcon';
import InstagramIcon from '@/svgs/InstagramIcon';
import LanguagesIcon from '@/svgs/LanguagesIcon';
import Logo from '@/svgs/Logo';
import RatingIcon from '@/svgs/RatingIcon';
import SettingsIcon from '@/svgs/SettingsIcon';
import StartIcon from '@/svgs/StartIcon';
import TutorialIcon from '@/svgs/TutorialIcon';
import YouTubeIcon from '@/svgs/YouTubeIcon';

import styles from './MainMenu.module.scss';

export default function MainMenu({
  content,
}: {
  content?: {
    contact?: string,
    languages?: string,
    rating?: string,
    settings?: string,
    start?: string,
    title?: string,
    tutorial?: string,
    instagram?: string,
    facebook?: string,
    youtube?: string,
    mjb?: string,
  };
}) {
  const {
    handleSetContact,
    handleSetDefault,
    handleSetLanguages,
    handleSetRating,
    handleSetSettings,
    handleSetStart,
    handleSetTutorial,
  } = useContext(MenuContext);

  return (
    <SubmenuTemplate title="Menu" handleClose={handleSetDefault}>
      <section className={styles.MainMenu}>
        <nav className={styles.navigation}>
          <ol>
            <li className={styles.option}>
              <button type="button" onClick={handleSetLanguages}>
                <LanguagesIcon /> {content?.languages}
              </button>
            </li>
            <li className={styles.option}>
              <button type="button" onClick={handleSetSettings}>
                <SettingsIcon /> {content?.settings}
              </button>
            </li>
            <li className={styles.option}>
              <button type="button" onClick={handleSetRating} disabled>
                <RatingIcon /> {content?.rating}
              </button>
            </li>
            <li className={styles.option}>
              <button type="button" onClick={handleSetContact} disabled>
                <ContactIcon /> {content?.contact}
              </button>
            </li>
            <li className={styles.option}>
              <button type="button"  onClick={handleSetTutorial} disabled>
                <TutorialIcon /> {content?.tutorial}
              </button>
            </li>
            <li className={styles.option}>
              <button type="button" onClick={handleSetStart} disabled>
                <StartIcon /> {content?.start}
              </button>
            </li>
          </ol>
          <footer className={styles.footer}>
            <h4 className={styles['footer-logo']}><Logo /></h4>
            <ul className={styles['social-list']}>
              {!!content?.instagram?.length && (
                <li>
                  <a href={content.instagram} target="_blank" aria-label="Ir para o Instagram">
                    <InstagramIcon />
                  </a>
                </li>
              )}
              {!!content?.facebook?.length && (
                <li>
                  <a href={content.facebook} target="_blank" aria-label="Ir para o Facebook" >
                    <FacebookIcon />
                  </a>
                </li>
              )}
              {!!content?.youtube?.length && (
                <li>
                  <a href={content.youtube} target="_blank" aria-label="Ir para o YouTube">
                    <YouTubeIcon />
                  </a>
                </li>
              )}
            </ul>
            {!!content?.mjb?.length && (
              <p className={styles.link}>
                <a
                  href={content?.mjb}
                  target="_blank"
                  aria-label="Ir para o site do Museu do Jardim Botânico"
                >
                  {content.mjb.replace(/^https?:\/\//, '')}
                </a>
              </p>
            )}
          </footer>
        </nav>
      </section>
    </SubmenuTemplate>
  );
};
