import React from 'react';

import AudioPlayer from '@/components/AudioPlayer';
import BasicCover from '@/components/BasicCover';
import { getAbsoluteUploadUrl } from '@/utils/getAbsoluteUploadUrl';
import { FileType } from '@/types';

import styles from './AudioContentSession.module.scss';

export default function AudioContentSession({
  audios = [], cover, title = '',
}: {
  audios: FileType[]; cover?: FileType; title?: string;
}) {
  return (
    <section className={styles.AudioContentSession}>
      {!!cover?.url?.length && !!cover?.height && !!cover?.width && (
        <div className={styles['cover-wrapper']}>
          <BasicCover cover={cover} />
        </div>
      )}
      {!!title?.length && (<h4 className={styles.title}>{title}</h4>)}
      {!!audios?.length && audios.map((a) => {
        if (!!a?.id && a?.url?.length) {
          let name = a?.caption;

          if (!name?.length) {
            name = a?.alternativeText;
          }

          return (
            <div key={a.id} className={styles['player-wrapper']}>
              {!!name?.length && (<h5 className={styles['audio-name']}>{name}</h5>)}
              {!!a?.caption?.length}
              {/* API NOTE: Adicionar ENV VAR */}
              <AudioPlayer
                src={getAbsoluteUploadUrl(a.url)}
              />
            </div>
          );
        }

        return null;
      })}
    </section>
  );
};
