import { Locale, i18n } from '@/i18n.config';

type DictionariesType = {
  pt: any;
  en: any;
  es: any;
  libras: any;
  'pt-au': any;
}

const dictionaries: DictionariesType = {
  pt: () => import('@/dictionaries/pt.json').then(module => module.default),
  en: () => import('@/dictionaries/en.json').then(module => module.default),
  es: () => import('@/dictionaries/es.json').then(module => module.default),
  libras: () => import('@/dictionaries/libras.json').then(module => module.default),
  'pt-au': () => import('@/dictionaries/pt-au.json').then(module => module.default),
}

export const getDictionary = async (locale: Locale) => (
  dictionaries[i18n.locales.includes(locale) ? locale : i18n.defaultLocale]()
);
