'use client';

import { createContext, useState } from 'react';

const SettingsContext = createContext({} as any);

export function SettingsProvider({ children }: { children: React.ReactNode }) {
  const [camera, setCamera] = useState<boolean>(false);
  const [fontSize, setFontSize] = useState<boolean>(false);
  const [highContrast, setHighContrast] = useState<boolean>(false);
  const [screenReader, setScreenReader] = useState<boolean>(false);

  const handleSetCamera = (value: boolean) => { setCamera(value) };

  const handleSetFontSize = (value: boolean) => { setFontSize(value) };

  const handleSetHighContrast = (value: boolean) => { setHighContrast(value) };

  const handleSetScreenReader = (value: boolean) => { setScreenReader(value) };

  return (
    <SettingsContext.Provider
      value={{
        camera,
        fontSize,
        highContrast,
        screenReader,
        handleSetCamera,
        handleSetFontSize,
        handleSetHighContrast,
        handleSetScreenReader,
      }}
    >
      {children}
    </SettingsContext.Provider>
  );
};

export default SettingsContext;
