'use client';

import { createContext, useState } from 'react';

const MessageContext = createContext({} as any);

export function MessageProvider({ children }: { children: React.ReactNode }) {
  const [email, setEmail] = useState<string>('');
  const [feedback, setFeedback] = useState<string>('');
  const [fullName, setFullName] = useState<string>('');
  const [message, setMessage] = useState<string>('');
  const [topic, setTopic] = useState<string>('');
  const [rating, setRating] = useState<number>(0);

  const handleSetEmail = (value: string) => { setEmail(value) };

  const handleSetFullName = (value: string) => { setFullName(value) };

  const handleSetMessage = (value: string) => { setMessage(value) };

  const handleSetFeedback = (value: string) => { setFeedback(value) };

  const handleSetTopic = (value: string) => { setTopic(value) };

  const handleSetRating = (value: number) => { setRating(value) };

  const handleSubmitRating = (event: React.FormEvent<HTMLFormElement>) => {
    event?.preventDefault();

    console.log(
      `Estrelas: ${
        rating
      } | Nome: ${
        fullName
      } | E-mail: ${
        email
      } | Tópico: ${
        topic
      } | Mensagem: ${
        feedback
      }`,
    );
  };

  return (
    <MessageContext.Provider
      value={{
        email,
        feedback,
        fullName,
        message,
        topic,
        rating,
        handleSetEmail,
        handleSetFeedback,
        handleSetFullName,
        handleSetMessage,
        handleSetRating,
        handleSetTopic,
        handleSubmitRating,
      }}
    >
      {children}
    </MessageContext.Provider>
  );
};

export default MessageContext;
