import React, { useContext } from 'react';

import SubmenuTemplate from '@/templates/SubmenuTemplate';
import MenuContext from '@/context/MenuContext/MenuContext';
import { TutorialMenuContentType } from '.';

export default function SettingsMenuContent({ content }: { content?: TutorialMenuContentType }) {
  const { handleSetDefault, handleSetMainMenu } = useContext(MenuContext);

  return (
    <SubmenuTemplate
      title={content?.title}
      handleClose={handleSetDefault}
      handleRegress={handleSetMainMenu}
    />
  );
};
