import React, { useContext } from 'react';

import SubmenuTemplate from '@/templates/SubmenuTemplate';
import RatingForm from '@/sections/RatingForm';
import StarRating from '@/components/StarRating';
import MenuContext from '@/context/MenuContext/MenuContext';
import MessageContext from '@/context/MessageContext/MessageContext';
import { RatingMenuContentType } from '.';

import styles from './RatingMenuContent.module.scss';

export default function RatingMenuContent({ content }: { content?: RatingMenuContentType }) {
  const { rating, handleSetRating } = useContext(MessageContext);

  const { handleSetDefault, handleSetMainMenu } = useContext(MenuContext);

  const {
    description,
    emailPlaceholder,
    formDescription,
    messagePlaceholder,
    namePlaceholder,
    title,
    topicPlaceholder,
    submit,
    topicOptions,
  } = content as RatingMenuContentType;

  return (
    <SubmenuTemplate
      title={title}
      handleClose={handleSetDefault}
      handleRegress={handleSetMainMenu}
    >
      <div className={styles.RatingMenuContent}>
        <p>{description}</p>
        <div className={styles['star-rating-wrapper']}>
          <StarRating value={rating} setValue={handleSetRating} />
        </div>
        <div className={styles['contact-wrapper']}>
          <RatingForm
            description={formDescription}
            emailPlaceholder={emailPlaceholder}
            messagePlaceholder={messagePlaceholder}
            namePlaceholder={namePlaceholder}
            submit={submit}
            topicPlaceholder={topicPlaceholder}
            topicOptions={topicOptions || []}
          />
        </div>
      </div>
    </SubmenuTemplate>
  );
};
