import React, { useContext } from 'react';

import LocaleSwitcher from '@/components/LocaleSwitcher';
import SubmenuTemplate from '@/templates/SubmenuTemplate';
import MenuContext from '@/context/MenuContext/MenuContext';

import styles from './LanguageMenuContent.module.scss';

export default function LanguageMenuContent({
  description = 'Selecione o idioma desejado',
  lang,
  title = 'Idiomas',
}: {
  description?: string;
  lang: string;
  title?: string;
}) {
  const { handleSetDefault, handleSetMainMenu } = useContext(MenuContext);

  return (
    <SubmenuTemplate
      title={title}
      handleClose={handleSetDefault}
      handleRegress={handleSetMainMenu}
    >
      <div className={styles.LanguageMenuContent}>
        <p>{description}</p>
        <LocaleSwitcher selected={lang} />
      </div>
    </SubmenuTemplate>
  );
};
