import React, { useContext } from 'react';

import SubmenuTemplate from '@/templates/SubmenuTemplate';
import ContactForm from '@/sections/ContactForm';
import MenuContext from '@/context/MenuContext/MenuContext';
import { ContactMenuContentType } from '.';

import styles from './ContactMenuContent.module.scss';

export default function ContactMenuContent({ content }: { content?: ContactMenuContentType }) {
  const { handleSetDefault, handleSetMainMenu } = useContext(MenuContext);

  const {
    description,
    emailPlaceholder,
    messagePlaceholder,
    namePlaceholder,
    title,
    topicPlaceholder,
    submit,
    topicOptions,
  } = content as ContactMenuContentType;

  return (
    <SubmenuTemplate
      title={title}
      handleClose={handleSetDefault}
      handleRegress={handleSetMainMenu}
    >
      <div className={styles.ContactMenuContent}>
        <ContactForm
          description={description}
          emailPlaceholder={emailPlaceholder}
          messagePlaceholder={messagePlaceholder}
          namePlaceholder={namePlaceholder}
          submit={submit}
          topicPlaceholder={topicPlaceholder}
          topicOptions={topicOptions || []}
        />
      </div>
    </SubmenuTemplate>
  );
};
