import React from 'react';

import styles from './ToggleButton.module.scss';

export default function ToggleButton({
  ariaLabel = 'Ativar ou desativar',
  selected = false,
  setSelected,
}: {
  ariaLabel?: string;
  selected?: boolean;
  setSelected: (value: boolean) => void;
}) {
  return (
    <button
      className={styles[`ToggleButton${selected ? '--selected' : ''}`]}
      type="button"
      aria-label={ariaLabel}
      onClick={() => setSelected(!selected)}
    >
      <div className={styles.rail} />
      <div className={styles.circle} />
    </button>
  );
};
