import React from 'react';

import styles from './TextareaField.module.scss';

export default function TextareaField({
  value = '',
  placeholder = '',
  rows = 6,
  onChange,
}: {
  value?: string;
  placeholder?: string;
  rows?: number;
  onChange?: (value: string) => void;
}) {
  return onChange && (
    <textarea
      className={styles.TextareaField}
      value={value}
      placeholder={placeholder}
      rows={rows}
      onChange={({ target }) => onChange(target?.value || '')}
    />
  );
};
