import React, { ReactNode } from 'react';

import styles from './SwitchButton.module.scss';

export default function SwitchButton({
  selected = false,
  options = [],
  setSelected,
}: {
  selected?: boolean;
  options?: {
    id: string;
    ariaLabel?: string;
    icon: ReactNode;
  }[];
  setSelected: (value: boolean) => void;
}) {
return (
  <div className={styles.SwitchButton}>
    <button
      className={styles[`option${!selected ? '--active' : ''}`]}
      type="button"
      aria-label={options?.[0]?.ariaLabel || 'Ativar primeira opção'}
      onClick={() => setSelected(false)}
    >
      {options?.[0]?.icon || null}
    </button>
    <button
      className={styles[`option${selected ? '--active' : ''}`]}
      type="button"
      aria-label={options?.[1]?.ariaLabel || 'Ativar primeira opção'}
      onClick={() => setSelected(true)}
    >
      {options?.[1]?.icon || null}
    </button>
  </div>
);
};
