import React from 'react';

import SelectArrowIcon from '@/svgs/SelectArrowIcon';

import styles from './SelectField.module.scss';

export default function SelectField({
  value = '',
  placeholder = '',
  options = [],
  onChange,
}: {
  value?: string;
  placeholder?: string;
  options?: { value: string, name: string }[],
  onChange?: (v: string) => void;
}) {  
  return !!options?.length && !!onChange && (
    <div className={styles.SelectField}>
      <select
        className={styles.field}
        defaultValue={value}
        onChange={({ target }) => onChange(target?.value || '')}
      >
        <option value="" disabled>{placeholder}</option>
        {options.map((opt) => (
          <option key={opt.value} value={opt.value}>{opt.name}</option>
        ))}
      </select>
      <SelectArrowIcon />
    </div>
  );
};
