import React from 'react';

import LinkItem from '@/components/LinkItem';
import { formatFloor } from '@/utils/formatFloor';
import { Locale } from '@/i18n.config';
import { RoomType } from '@/types';

export default function RoomLinkItem({
  lang, room: { floor = 0, name, slug, title },
}: {
  lang: Locale; room: RoomType;
}) {
  const path = `/${formatFloor(floor)}/${slug}`;

  if (!!name?.length && !!title?.length && !!path?.length) {
    return (
      <LinkItem lang={lang} name={name} title={title} path={path} />
    );
  }

  return null;
};
